package gov.va.caret.controller.dashboard.config;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

import javax.portlet.PortletRequest;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.AdhocReport;
import gov.va.caret.view.CachedReport;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ReportParameter;
import gov.va.caret.view.ResultMap;

public class VisnDashboardConfig extends CscDashboardConfig {

	private static final long serialVersionUID = 1L;
	private static GenericReport APP_DELAY = new AdhocReport( "appDelay", ReportParameter.classPk ){
		public String getPageName() {
			return "appDelay";
		}
		public String getOrderBy() {
			return "creationDate";
		}
		public boolean isDesc() {
			return true;
		}
		public boolean isLazy(){
			return true;
		}
	};
	
	public VisnDashboardConfig() {
		this.reports = new GenericReport[]{ 
				APP_DELAY, 
				new GenericReport("myApplicationWork", true, "creationDate", true, ReportParameter.userId, ReportParameter.queId ),
				new GenericReport("myNotes", true, "creationDate", true, GenericReport.NOTES_QUERY_NDX, ReportParameter.userId ),
				new CachedReport("persnAudit"),
				new CachedReport("persn"),
				new CachedReport("workAudit"),
				new CachedReport("vcgAudit"),
				new CachedReport("assmtAudit"),
				new CachedReport("assmtAuditAll"),
				new CachedReport("assmtAuditPeriodicAll"),
				new CachedReport("periodicAssessmentsAll"),
				new CachedReport("vcgSupportingDocsAll"),
				new CachedReport("vcgDocsHistoryAll")
			};
	
		searchableWork = new HashSet<String>(Arrays.asList(new String[]{
				WorkType.CSC_APP.name(), 
				WorkType.ONLINE_APP.name(), 
				WorkType.CSC_WAIVER.name(), 
				WorkType.APP_DELAY.name()}));
	}
	
	public GenericReport getReport (String name){
		for ( GenericReport report: enabledSearch.getCachedReports() ){
			if ( name.equals( report.getName() ) ){
				return report;
			}
		}
		for ( GenericReport report: reports ){
			if ( name.equals( report.getName() ) ){
				return report;
			}
			if ( name.startsWith("appDelay") ){
				return APP_DELAY;
			}
		}
		return null;
	}
	
	public void configureFacility(PortletRequest request) throws ApplicationWorkFlowException {
		super.configureFacility(request);
		if ( CAction.canDoCaret(request, CAction.CaretCan.VISN_CSC_WAIVER_Q ) ){
			request.setAttribute("appDelay", true );
			searchableWork.add( WorkType.APP_DELAY.name() );
		}
		ResultMap.getCaretMap(request).put( "CREATE_DNS _WAIVER", CAction.canDoCaret( request, CAction.CaretCan.CREATE_DNS _WAIVER ) );
	}
	
	
	@Override
	public void loadReports(PortletRequest request) throws ApplicationWorkFlowException {
		super.loadReports(request);
		if ( request.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG) instanceof FacilityDashboardConfig ) {
			Map<Long, String> orgMap = Toolbox.getVhaOrgList( request );
			ResultMap.getCaretMap(request).put( CaretStrPool.VHA_MEMBER, orgMap );
			for ( Long orgId : orgMap.keySet() ){
				ResultMap.getResultTotalMap( request ).put( "appDelay"+orgId, 
					CaretLocalServiceUtil.getReportCount( "appDelay", orgId) );
			}
		}
	}
	
	public CAction.CaretCan[] getCreateActions(){
		return new CAction.CaretCan[]{};
	}
	
	@Override
	public CaretCan[] getToolsActions() {
		return new CAction.CaretCan[]{};
	}
	
	@Override
	public String getView() {
		return "/jsp/dashboard/visn.jsp";
	}
}
